# ACE-Tray_Config_Fixed.ps1
# 此脚本用于配置多个进程的优先级和CPU关联性

# 要监控和配置的进程名称列表
$processNames = @("ACE-Tray", "SGuard64", "SGuardSvc64")

# 已配置的进程列表，避免重复配置
$configuredProcesses = @{}

# 先配置 ACE-Tray（开机就有的进程）
Write-Host "Waiting for ACE-Tray to start..."
while ($true) {
    $aceProcess = Get-Process -Name "ACE-Tray" -ErrorAction SilentlyContinue
    if ($aceProcess) {
        foreach ($proc in $aceProcess) {
            try {
                $proc.PriorityClass = [System.Diagnostics.ProcessPriorityClass]::Idle
                $proc.ProcessorAffinity = 2048
                $configuredProcesses[$proc.Id] = $true
                Write-Host "✓ ACE-Tray configured (PID: $($proc.Id))"
            }
            catch {
                Write-Host "Error configuring ACE-Tray: $($_.Exception.Message)"
            }
        }
        break
    }
    Start-Sleep -Seconds 3
}

Write-Host "Starting real-time monitoring for SGuard64 and SGuardSvc64..."
Write-Host "Monitoring is now active..."

# 实时监控 SGuard64 和 SGuardSvc64
while ($true) {
    foreach ($name in @("SGuard64", "SGuardSvc64")) {
        $processes = Get-Process -Name $name -ErrorAction SilentlyContinue
        
        foreach ($proc in $processes) {
            # 检查是否已经配置过这个进程实例
            if (-not $configuredProcesses.ContainsKey($proc.Id)) {
                try {
                    # 设置进程优先级为低（空闲）
                    $proc.PriorityClass = [System.Diagnostics.ProcessPriorityClass]::Idle
                    
                    # 设置CPU关联性为CPU 11（位掩码2048）
                    $proc.ProcessorAffinity = 2048
                    
                    # 标记为已配置
                    $configuredProcesses[$proc.Id] = $true
                    
                    Write-Host "✓ $name configured (PID: $($proc.Id)) - $(Get-Date -Format 'HH:mm:ss')"
                }
                catch {
                    Write-Host "Error configuring $name (PID: $($proc.Id)): $($_.Exception.Message)"
                }
            }
        }
    }
    
    # 清理已退出的进程记录
    $activeProcessIds = Get-Process | Select-Object -ExpandProperty Id
    $keysToRemove = @()
    foreach ($key in $configuredProcesses.Keys) {
        if ($key -notin $activeProcessIds) {
            $keysToRemove += $key
        }
    }
    foreach ($key in $keysToRemove) {
        $configuredProcesses.Remove($key)
        Write-Host "Cleaned up process record (PID: $key) - $(Get-Date -Format 'HH:mm:ss')"
    }
    
    # 短暂等待后继续实时监控（1秒间隔）
    Start-Sleep -Seconds 1
}